#ifndef DATABALL_H_
#define DATABALL_H_

#include "DataEntity.h"
#include "DataSphere.h"
namespace DataTypes
{

class DataBall : public DataTypes::DataEntity
{
public:
	DataBall();
	DataBall(int entityid, int materialid, float mass,Vector3f position, float radius, Vector3f rotation, Vector3f linearvelocity, Vector3f angularvelocity);
	virtual ~DataBall();
	float GetRadius();
	Vector3f GetPosition();
	Vector3f GetRotation();
	Vector3f GetLinearVelocity();
	Vector3f GetAngularVelocity();
	int GetMaterialId();
	float GetMass();
	void SetMass(float value);
	void SetRadius(float value);
	void SetPosition(Vector3f value);
	void SetRotation(Vector3f value);
	void SetMateriaId(int value);
private:
	int materialid;
	float mass;
	float radius;
	Vector3f position;
	Vector3f rotation;
	Vector3f linearvelocity;
	Vector3f angularvelocity;	
};

}

#endif /*DATABALL_H_*/
